const EventEmitter = require('events');
const uuid = require('uuid');

// Create logger class
class Logger extends EventEmitter {
    log(msg) {
        // Call event
        this.emit('message', { id: uuid.v4(), msg });
    };
}

// Example of use case
const logger = new Logger();
logger.on('message', (data) => console.log('Called listener', data));

logger.log('Hello World!');
logger.log('Hello Paulo!');
logger.log('Learning Node.js!');